local PANEL = {};

// link to class
function PANEL:LinkToClass( cls )
	self.LinkedClass = cls;
	
end

// init
function PANEL:Init( )
	// linked class
	self.LinkedClass = nil;
	
	// label
	self.Label = vgui.Create( "label", self );
	self.Label:SetMouseInputEnabled( false );
	
	// icon
	self.Icon = nil;
	self.Text = "";
	
	// the treeview we're bound to.
	self.ListBox = nil;
	
	// selected?
	self.Selected = false;
	
	// images
	self.Image = 0;
	self.SelectedImage = 0;
	
end

// set icon
function PANEL:SetIcon( mat )
	// create
	if( !self.Icon ) then
		self.Icon = vgui.Create( "ctl_icon", self );
		self.Icon:SetMouseInputEnabled( false );
		
	end
	
	// full texture.
	if( type( mat ) == "string" ) then
		self.Icon:SetMaterial( mat );
		
	// imagelist?
	elseif( type( mat ) == "number" && self.ListBox && self.ListBox.ImageList ) then
		local texture = self.ListBox.ImageList:Get( mat );
		if( texture ) then
			self.Icon.Material = texture;
			
		end
	
	end
	
end

// set images.
function PANEL:SetImages( normal, selected )
	self.Image = normal;
	self.SelectedImage = selected;
	
	// normal
	if( self.Image && !self.Selected ) then
		self:SetIcon( self.Image );
	
	// selected
	elseif( self.SelectedImage && self.Selected ) then
		self:SetIcon( self.SelectedImage );
		
	end
end

// set text
function PANEL:SetText( txt )
	self.Label:SetText( txt );
	self.Text = txt;
	
end

function PANEL:GetText( )
	return self.Text;
	
end

// get/set selected
function PANEL:GetSelected( )
	return self.Selected;
	
end

// set selected
function PANEL:SetSelected( v )
	self.Selected = v;
	
	// normal
	if( self.Image && !self.Selected ) then
		self:SetIcon( self.Image );
	
	// selected
	elseif( self.SelectedImage && self.Selected ) then
		self:SetIcon( self.SelectedImage );
		
	end
	
end


// select our node.
function PANEL:OnMousePressed( )
	// if we have a treeview, deselect previous node, and select this one.
	if( self.ListBox ) then
		// select this node.
		self.ListBox:SetSelectedItem( self );
		
	end

end

// perform layout
function PANEL:PerformLayout( )
	// offset
	local ofsx = 4;
		
	// position the icon if we have one.
	if( self.Icon ) then
		// position icon
		self.Icon:SetSize( 16, 16 );
		self.Icon:SetPos( ofsx, 0 );
		
		// shift offset.
		ofsx = ofsx + 18;
		
	end
	
	// position label.
	self.Label:SizeToContents();
	self.Label:SetPos( ofsx, 8 - self.Label:GetTall() * 0.5 );
	
	// size myself
	self:SetSize( ofsx + self.Label:GetWide() + 16, 16 );
	
end

// scheme
function PANEL:ApplySchemeSettings( )
	// set fonts.
	self.Label:SetFont( AppFramework:Theme().fonts['text'] );
	self.Label:SetFGColor( AppFramework:Theme().colors['text'] );
	
end

// paint.
function PANEL:Paint( )
	// draw selection box.
	if( self:GetSelected() ) then
		// get select size.
		local x, y = self.Label:GetPos();
		local w, h = self.Label:GetSize();
		
		// draw
		local color = AppFramework:Theme().colors['selection'];
		surface.SetDrawColor(
			color.r,
			color.g,
			color.b,
			color.a
		);
		surface.DrawRect(
			x, y,
			w, h
		);
	end
	
	//
	return true;
	
end

// set treeview.
function PANEL:SetListBox( list )
	self.ListBox = list;
	
end

// register
vgui.Register( "ctl_listboxnode", PANEL, "Panel" );

